"use strict";(globalThis.webpackChunk_plex_client_qt=globalThis.webpackChunk_plex_client_qt||[]).push([["packages_visualizer_shaders_galaxy_glsl"],{57643:e=>{e.exports="// https://www.shadertoy.com/view/MslGWN\nprecision mediump float;\n\nuniform float uTime;\nuniform vec2 uResolution;\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nuniform sampler2D uSampler;\n\n//CBS\n//Parallax scrolling fractal galaxy.\n//Inspired by JoshP's Simplicity shader: https://www.shadertoy.com/view/lslGWr\n\n// http://www.fractalforums.com/new-theories-and-research/very-simple-formula-for-fractal-patterns/\nfloat field(in vec3 p,float s) {\n  float strength = 7. + .03 * log(1.e-6 + fract(sin(uTime) * 4373.11));\n  float accum = s/4.;\n  float prev = 0.;\n  float tw = 0.;\n  for (int i = 0; i < 26; ++i) {\n    float mag = dot(p, p);\n    p = abs(p) / mag + vec3(-.5, -.4, -1.5);\n    float w = exp(-float(i) / 7.);\n    accum += w * exp(-strength * pow(abs(mag - prev), 2.2));\n    tw += w;\n    prev = mag;\n  }\n  return max(0., 5. * accum / tw - .7);\n}\n\n// Less iterations for second layer\nfloat field2(in vec3 p, float s) {\n  float strength = 7. + .03 * log(1.e-6 + fract(sin(uTime) * 4373.11));\n  float accum = s/4.;\n  float prev = 0.;\n  float tw = 0.;\n  for (int i = 0; i < 18; ++i) {\n    float mag = dot(p, p);\n    p = abs(p) / mag + vec3(-.5, -.4, -1.5);\n    float w = exp(-float(i) / 7.);\n    accum += w * exp(-strength * pow(abs(mag - prev), 2.2));\n    tw += w;\n    prev = mag;\n  }\n  return max(0., 5. * accum / tw - .7);\n}\n\nvec3 nrand3( vec2 co )\n{\n  vec3 a = fract( cos( co.x*8.3e-3 + co.y )*vec3(1.3e5, 4.7e5, 2.9e5) );\n  vec3 b = fract( sin( co.x*0.3e-3 + co.y )*vec3(8.1e5, 1.0e5, 0.1e5) );\n  vec3 c = mix(a, b, 0.5);\n  return c;\n}\n\n\nvoid main( void ) {\n  vec2 uv = 2. * gl_FragCoord.xy / uResolution.xy - 1.;\n  vec2 uvs = uv * uResolution.xy / max(uResolution.x, uResolution.y);\n  vec3 p = vec3(uvs / 4., 0) + vec3(1., -1.3, 0.);\n  p += .2 * vec3(sin(uTime / 16.), sin(uTime / 12.),  sin(uTime / 128.));\n\n  float freqs[4];\n  //Sound\n  freqs[0] = texture2D( uSampler, vec2( 0.01, 0.25 ) ).x;\n  freqs[1] = texture2D( uSampler, vec2( 0.07, 0.25 ) ).x;\n  freqs[2] = texture2D( uSampler, vec2( 0.15, 0.25 ) ).x;\n  freqs[3] = texture2D( uSampler, vec2( 0.30, 0.25 ) ).x;\n\n  float t = field(p,freqs[2]);\n  float v = (1. - exp((abs(uv.x) - 1.) * 6.)) * (1. - exp((abs(uv.y) - 1.) * 6.));\n\n    //Second Layer\n  vec3 p2 = vec3(uvs / (4.+sin(uTime*0.11)*0.2+0.2+sin(uTime*0.15)*0.3+0.4), 1.5) + vec3(2., -1.3, -1.);\n  p2 += 0.25 * vec3(sin(uTime / 16.), sin(uTime / 12.),  sin(uTime / 128.));\n  float t2 = field2(p2,freqs[3]);\n  vec4 c2 = mix(.4, 1., v) * vec4(1.3 * t2 * t2 * t2 ,1.8  * t2 * t2 , t2* freqs[0], t2);\n\n\n  //Let's add some stars\n  //Thanks to http://glsl.heroku.com/e#6904.0\n  vec2 seed = p.xy * 2.0;\n  seed = floor(seed * uResolution.x);\n  vec3 rnd = nrand3( seed );\n  vec4 starcolor = vec4(pow(rnd.y,40.0));\n\n  //Second Layer\n  vec2 seed2 = p2.xy * 2.0;\n  seed2 = floor(seed2 * uResolution.x);\n  vec3 rnd2 = nrand3( seed2 );\n  starcolor += vec4(pow(rnd2.y,40.0));\n\n  gl_FragColor = mix(freqs[3]-.3, 1., v) * vec4(1.5*freqs[2] * t * t* t , 1.2*freqs[1] * t * t, freqs[3]*t, 1.0)+c2+starcolor;\n  gl_FragColor = vec4(gl_FragColor.rgb, 1.0);\n}\n"}}]);